`timescale 1ns/1ns

module tb_mram;

// inputs
reg  ce_b; 
reg  we_b; 
reg  oe_b; 
reg  lb_b; 
reg  ub_b;	  
reg  dbd_b;
reg  lvl; 
reg  dc;
reg  sleep;

wire  [15:0] dq;
reg  [15:0] d;
reg  [15:0] a;
reg  bga_x8;
reg  tsop_x8;
reg  err_flag;
reg [8:0] err_count;
reg [15:0] exp_data;
reg test_trig;
// testbench variables
integer i,j,k, l, m, n, cscnt;
parameter tsetup = 3;
parameter thold = 0;
parameter period = 100;
//----------------------------------------------------------------------------------------------------


initial
begin:simvision
	$dumpfile("sim.vcd");
	$dumpvars(0, ce_b, oe_b, we_b, ub_b, lb_b, a, dq, d, err_flag);
	#5000;
	$finish;

end

// set initial states
initial
begin:init_state
	ce_b       = 1'b1;
	we_b       = 1'b1;
	oe_b       = 1'b1;
	lb_b       = 1'b1;  
	ub_b       = 1'b1; 		     
	dc         = 1'b0;
	bga_x8     = 1'bx;
	tsop_x8    = 1'bx;
	sleep      = 1'bx; 
	lvl        = 1'bx; 
	dbd_b      = 1'bx;
	err_flag   = 1'b0;  	
	err_count  = 8'b0;
	
	d[15:0]    = 16'h0000;
	a[15:0]    = 16'h0000;
	
end

MR0A16A mram(a, dq, oe_b, ce_b, we_b, ub_b, lb_b);

assign dq = oe_b ? d : 16'hzzzz;

// -------------------------------------------------------------- //
// VCD Stimulus Section
// Change this portion only for new stimulus

initial
begin
      // DO NOT NEED POWER-UP FOR TESTER CODE
      //#20000                       //  power_up for 20
      #10
      a[15:0] = 16'hDEAD;
      #5;
      $display("Standard Writes at %g nS",$time);
      write(16'h0, 16'hABCD);
      write(16'hBEEF, 16'hAAAA);
      write(16'hDEAD, 16'h5555);
      write(16'hFFFF, 16'h1234);
     
	  tristate();
	  #10;
      oe_read(16'hBEEF, 16'hAAAA);
      oe_read(16'hDEAD, 16'h5555);
	  tristate();
	  #10;
	  $display("\nCE-controlled Write at %g nS",$time);
      ce_write(16'hBEEF, 16'h5555);
      oe_read(16'hBEEF, 16'h5555);
	  tristate();
      #10;

      write(16'hBEEF, 16'hFEED);
      write(16'hDEAD, 16'hF00D);
	  tristate();
	  #10;
      $display("\nOE-controlled read at %g nS",$time);
      oe_read(16'hBEEF, 16'hFEED);
      oe_read(16'hDEAD, 16'hF00D);
	  tristate();
	  #20;
      $display("\nCE/OE coincident read at %g nS",$time);
      ceoe_read(16'hBEEF, 16'hFEED);
      ceoe_read(16'hDEAD, 16'hF00D);
      #10;
	  tristate();
      #50;
	  
      $display("\nAddress-driven reads at %g nS",$time);
      a<= 16'hBEEF;
      #5;
      ce_b<=1'b0; 
      #1;
      oe_b<=1'b0;
      #period;
      test_data(16'hFEED);
      a<=16'hDEAD;
	  #1;
	  err_flag<=0;
	  #3;
	  test_data(16'hxxxx); // check invalid data-out
      #(period-3);
      test_data(16'hF00D);
	  lb_b<=1;
	  #10;
      test_data(16'hF0zz);
	  ub_b<=1;
	  #10;
      test_data(16'hzzzz);
	  ub_b<=0;
	  lb_b<=0;
	  #10;
      test_data(16'hF00D);
      a<=16'h0000;
      #period;
      test_data(16'hABCD);
      a<=16'hFFFF;
      #period;
      test_data(16'h1234);
      a<=a+1;
      #period;
      if (err_count>0) $display("\n**** Total of %d errors ****\n",err_count);
      $finish;
end
// end of stimulus section
// --------------------------------------------------------------- //


// ----------------------------------------------------------------//
// Task Section
task write;
input [20:0] wr_a;
input [15:0] data;
begin
     oe_b <= 1'b1;
     lb_b <= 1'b0;
     ub_b <= 1'b0;
     d[15:0] <= data;
     a[15:0] <= wr_a;
     #tsetup;
     ce_b <= 1'b0;
     we_b <= 1'b0;
	 #period;
     #5;
     ce_b<=1'b1;
	 we_b<=1'b1;
end
endtask

task tristate;
begin
     d[15:0] <= 16'hzzzz;
     a[15:0] <= 16'hzzzz;
end
endtask

task ce_write;
input [15:0] wr_a;
input [15:0] data;
begin
     oe_b <= 1'b1;
     lb_b <= 1'b0;
     ub_b <= 1'b0;
     d[15:0] <= data;
     a[15:0] <= wr_a;
     #tsetup;
     ce_b <= 1'b0;
     we_b <= 1'b0;
     #period;
     ce_b <= 1'b1; 
	 #5;
	 we_b <= 1'b1;
end
endtask

task oe_read;
input [15:0] rd_a;
input [15:0] exp_data;
begin
     a[15:0] <= rd_a;
     ce_b <= 1'b0;  
     we_b <= 1'b1; 
     lb_b <= 1'b0;    
     ub_b <= 1'b0; 		     
     #5;
     oe_b <= 1'b0; 
     #period; 
     test_data(exp_data);
     #5;
     ce_b <=1'b1; 
	 oe_b <=1'b1;
     #20;
end
endtask

task ceoe_read;
input [15:0] rd_a;
input [15:0] exp_data;
begin
     a[15:0] <= rd_a;
     ce_b <= 1'b0;
     oe_b <= 1'b0; 
     we_b <= 1'b1; 
     lb_b <= 1'b0;    
     ub_b <= 1'b0; 		     
     #period; 
     test_data(exp_data);
     #5;
     ce_b <= 1'b1;
	 oe_b <= 1'b1;
     #20;
end
endtask

task test_data; // schedule an output check
input [15:0] data;
begin
	exp_data <= data;
	test_trig <=1;
	#1 test_trig <=0;
end
endtask

always@(posedge test_trig)
begin
     #1;
     if (exp_data[15:0]===dq[15:0]) err_flag<=0;
     else 
      begin
       err_flag <=1'bx;
	   err_count <=err_count+1;
       $display("*** %gnS: DATA ERROR at a=%H - %H vs exp %H",$time, a, dq[15:0], exp_data);
      end
end

// end of task section
// ----------------------------------------------------------------//


endmodule