---------------------------------------------------------------------
-- Project : MR25H10 VHDL TestBench
-- Release : 1.0
---------------------------------------------------------------------
-- Unit : test bench for 1M SPI MRAM
-- Date : August 2010
---------------------------------------------------------------------
---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------

-----------------------------------------------------------
-- TEST BENCH
-----------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
LIBRARY WORK;

LIBRARY STD;
USE STD.TEXTIO.ALL;

-----------------------------------------------------------
ENTITY BENCHTEST IS
END BENCHTEST;

-----------------------------------------------------------
-- Test architecture:
-----------------------------------------------------------
ARCHITECTURE TEST OF BENCHTEST IS

COMPONENT MR25H10_DRIVER
---------------------------------------

Port ( SCKT, SIT, CST, HOLDT, WPT: OUT Std_Logic;
       SOT: IN Std_logic);
---------------------------------------
 END COMPONENT ;

COMPONENT MR25H10
---------------------------------------
---------------------------------------
   Generic (
   		tRI:	Time;
                tRF:	Time;
                tWH:	Time;
                tWL:	Time;
                tCS:	Time;
                tCSS:	Time;
                tCSH:	Time;
                tSU:	Time;
                tH:	Time;
                tV:	Time;
                tHO:	Time;
                tHD:	Time;
                tCD:	Time;
                tLZ:	Time;
                tHZ:	Time;
                tWPS:	Time;
                tWPH:	Time;
                tDP:	Time;
         	tRDP:	Time;
                tDIS:	Time;
                Datafile       : STRING;
                memoryUpdate        : BOOLEAN);

PORT (
        SCK		: IN    std_logic;
        SI		: IN    std_logic;
        SO		: OUT   std_logic;
        CS		: IN    std_logic;
        HOLD		: IN    std_logic;
        WP		: IN   std_logic
    );
    
---------------------------------------
END COMPONENT ;

SIGNAL SCKtest, SItest, SOtest, CStest, HOLDtest, WPtest : STD_LOGIC;

-----------------------------------------------------------
-- body of structural architecture
-----------------------------------------------------------
BEGIN

TESTER : MR25H10_DRIVER

PORT MAP (SCKT => SCKtest, SIT => SItest, SOT => SOtest, CST => CStest, HOLDT => Holdtest, WPT => WPtest);


MEMORY : MR25H10
GENERIC MAP (
		50 ns,	-- Input Rise Time
                50 ns,	-- Input Fall Time
                11 ns,	-- SCK High Time
                11 ns,	-- SCK Low Time
                40 ns,	-- CS High Time
                10 ns,	-- CS Setup Time
                10 ns,	-- CS Hold Time
                5 ns,		-- Data In Setup Time
                5 ns,		-- Data Hold Time
                0 ns,		-- Output Valid Time
                0 ns,		-- Output Hold Time
                10 ns,	-- Hold Setup Time
                10 ns,	-- Hold Hold Time
                20 ns,	-- Hold to Output Low Impedance
                20 ns,	-- Hold to Output High Impedance
                5 ns,		-- WP Setup to CS
                5 ns,		-- WP Hold from CS
                3 ns,		-- Sleep Mode Entry Time
         	3 ns,		-- Sleep Mode Exit Time
                12 ns,	-- Output Disable Time
                
                "MR25H10.txt",
                 TRUE)
                      
                      
PORT MAP (SCK => SCKtest, SI => SItest, SO => SOtest, CS => CStest, HOLD => Holdtest, WP => WPtest);


END TEST;

---------------------------------------------------------------------------
configuration CFG_BENCHTEST of BENCHTEST is
	for TEST
	end for;
end CFG_BENCHTEST;

----------------------------------------------------------------------------






