-- VHDL Test Sequence Generator for the 1M SPI MRAM
-- Device Part Number: MR25H10
-- Device Data Sheet: http://www.everspin.com/PDF/EST_MR25H10_prod.pdf

-- Model Revision: 1.0
-- Model Release Date: August 2010

---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------
-----------------------------------------------------------
-- MR25H10 DRIVER
-----------------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE work.package_utility.ALL;
use ieee.std_logic_arith.all;
use ieee.numeric_std.all;

--=========================================================
-- ENTITY
--=========================================================
ENTITY MR25H10_DRIVER IS
-----------------------------------------------------------
       
Port ( SCKT, SIT, CST, HOLDT, WPT: OUT Std_Logic;
       SOT: IN Std_logic);
       
-----------------------------------------------------------
END MR25H10_DRIVER;

--=========================================================
ARCHITECTURE BENCH OF MR25H10_DRIVER IS
--=========================================================

SIGNAL SERIALCLOCK, SERIALIN, SERIALOUT, HOLDOUT, WRITEPROTECT, CHIPSELECT: STD_LOGIC := '1';

BEGIN
CHIPSELECT <= '1';

Clock: process

begin

SCKT <= '1'; WAIT FOR 100 ns;
SCKT <= '0'; WAIT FOR 100 ns;

END PROCESS;

driver: process

CONSTANT thigh : TIME := 50 ns;
CONSTANT tlow  : TIME := 50 ns;

begin

-----------------------------------------------------------------------------------
-- Start Test 
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Simple Unknown Command Cycle
-----------------------------------------------------------------------------------
WAIT FOR Thigh;

CST <= '1'; WPT <= '1'; HOLDT <= '1'; SIT <= '1';

WAIT FOR 3*Thigh;

CST <= '0';

WAIT FOR 32*Thigh;

CST <= '1';

-----------------------------------------------------------------------------------
-- Simple Read Command Cycle
-----------------------------------------------------------------------------------

WAIT FOR 3*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 24*Thigh;

SIT <= '1';

WAIT FOR 8*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 96*THIGH;

CST <= '0'; SIT <= '0';

WAIT FOR 32*Thigh;

CST <= '1';

WAIT FOR THIGH;

-----------------------------------------------------------------------------------
-- Simple Write Command Cycle
-----------------------------------------------------------------------------------

WAIT FOR 3*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 24*Thigh;

SIT <= '1';

WAIT FOR 4*Thigh;

SIT <= '0';

WAIT FOR 4*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 92*THIGH;

CST <= '0'; SIT <= '1';

WAIT FOR 4*THIGH;

SIT <= '0';

WAIT FOR 32*Thigh;

CST <= '1';

WAIT FOR THIGH;

-----------------------------------------------------------------------------------
-- Simple Read Command Cycle
-----------------------------------------------------------------------------------

WAIT FOR 3*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 24*Thigh;

SIT <= '1';

WAIT FOR 8*Thigh;

CST <= '0'; SIT <= '0';

WAIT FOR 92*THIGH;

CST <= '0'; SIT <= '1';

WAIT FOR 4*Thigh;

SIT <= '0';

WAIT FOR 32*Thigh;

CST <= '1';

WAIT FOR THIGH;




--------------------------------------------------------------------------------------
-- End of Test Bench
--------------------------------------------------------------------------------------

end process;

end BENCH;




