-- VHDL Test Sequence Generator for the 128K x 8 MRAM
-- Device Part Number: MR256A08B
-- Device Data Sheet: http://www.everspin.com/PDF/EST_MR256A08B_prod.pdf

-- Model Revision: 1.0
-- Model Release Date: July 2010

---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------
-----------------------------------------------------------
-- MR256A08B DRIVER
-----------------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE work.package_utility.ALL;
use ieee.std_logic_arith.all;
use ieee.numeric_std.all;

--=========================================================
-- ENTITY
--=========================================================
ENTITY MR256A08B_DRIVER IS
-----------------------------------------------------------

Port ( CE, WE, OE : OUT Std_Logic;
       Address : OUT Std_Logic_Vector(14 downto 0);
       Data : INOUT Std_Logic_Vector(7 downto 0):=(others=>'Z'));
       
      
-----------------------------------------------------------
END MR256A08B_DRIVER;

--=========================================================
ARCHITECTURE BENCH OF MR256A08B_DRIVER IS
--=========================================================

SIGNAL Chip_Enabled, Write_Enabled, Output_Enabled : STD_LOGIC := '0';
SIGNAL Address_outd: STD_Logic_Vector(14 downto 0);
SIGNAL Data_outd: STD_LOGIC_VECTOR(7 downto 0);


BEGIN
chip_enabled <= '1';

driver: process

CONSTANT thigh : TIME := 20 ns;
CONSTANT tlow  : TIME := 10 ns;

begin

-----------------------------------------------------------------------------------
-- Start Test 
-----------------------------------------------------------------------------------

WAIT FOR Thigh;
CE <= '0'; WE <= '1'; OE <= '1'; Data <= "11111111"; Address <= "000000000000001";

WAIT FOR 5*Thigh;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "ZZZZZZZZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Write, CE, WE Setup prior to write
------------------------------------------------------------------------------------
WAIT FOR 2*Thigh;
Data <= "11110000";
Address <= "000000000000000";
WAIT FOR 10*Thigh;
CE <= '0'; WE <= '0'; OE <= '1'; 

WAIT FOR 2*Thigh;
CE <= '0'; WE <= '1'; OE <= '1';

WAIT FOR 2.5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000011";

WAIT FOR Thigh;
Data <= "ZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Read
------------------------------------------------------------------------------------
WAIT for 5*thigh;
CE <= '0'; WE <= '1'; OE <= '0'; Address <= "000000000000000";

WAIT for 5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000";

-------------------------------------------------------------------
-- Start Write Test with CE Low and WE Pulsing for Write Completion
-------------------------------------------------------------------
WAIT FOR Thigh;
CE <= '0'; WE <= '1'; OE <= '1'; Address <= "000000000000001";

WAIT FOR Thigh;
WE <= '0'; Data <= "10101010";

WAIT FOR 2*Thigh;
WE <= '1'; 

WAIT FOR Thigh;
CE <= '1'; Address <= "ZZZZZZZZZZZZZZZ"; Data <= "ZZZZZZZZ";


------------------------------------------------------------------------------------
-- Test Address controlled reads
------------------------------------------------------------------------------------
Wait for 2*thigh;
WE <= '1'; CE <= '0'; OE <= '0'; 

Wait for thigh;
Address <= "000000000000000";

Wait for 5*thigh;
Address <= "000000000000001";

Wait for 5*thigh;
Address <= "000000000000010";

Wait for 5*thigh;
Address <= "000000000000011";

Wait for 3*thigh;
CE <= '1'; OE <= '1'; Address <= "ZZZZZZZZZZZZZZZ";

--------------------------------------------------------------------------------------
-- End of Test Bench
--------------------------------------------------------------------------------------

end process;

end BENCH;


