---------------------------------------------------------------------
-- Project : MR2A08A VHDL TestBench
-- Release : 1.0
---------------------------------------------------------------------
-- Unit : test bench
-- Date : July 2010
---------------------------------------------------------------------
---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------

-----------------------------------------------------------
-- TEST BENCH
-----------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
LIBRARY WORK;

LIBRARY STD;
USE STD.TEXTIO.ALL;

-----------------------------------------------------------
ENTITY BENCHTEST IS
END BENCHTEST;

-----------------------------------------------------------
-- Test architecture:
-----------------------------------------------------------
ARCHITECTURE TEST OF BENCHTEST IS

COMPONENT MR2A08A_DRIVER
---------------------------------------

Port ( CE, WE, OE : OUT Std_Logic;
      Address : OUT Std_Logic_Vector(18 downto 0);
       Data : INOUT Std_Logic_Vector(7 downto 0):=(others=>'Z'));
---------------------------------------
 END COMPONENT ;

COMPONENT MR2A08A
---------------------------------------
---------------------------------------
   Generic (Tavav:   TIME;
	            Tavqv:   TIME;
	            Taxqx:   TIME;
	            Telqv:   TIME;
	            Tqlqv:   TIME;
	           Tqhqz:   TIME;
	            Tehqz:   TIME;
	            Teleh:   TIME;
	            Tavwh:   TIME;
	            Twhax:   TIME;
	            Tavwl:   TIME;
	           Twlwh:   TIME;
	            Tdvwh:   TIME;
	            Twhdx:   TIME;
	            DataFile: STRING;
	            MemoryUpdate : Boolean);


Port ( E_b, W_b, G_b : IN Std_Logic;
       A : IN Std_Logic_Vector(18 downto 0);
       DQ : INOUT Std_Logic_Vector(7 downto 0));
---------------------------------------
END COMPONENT ;

SIGNAL CEtest, WEtest, OEtest : STD_LOGIC;
SIGNAL Addresstest: STD_Logic_Vector(18 downto 0);
SIGNAL Datatest1: STD_LOGIC_VECTOR(7 downto 0);


-----------------------------------------------------------
-- body of structural architecture
-----------------------------------------------------------
BEGIN

TESTER : MR2A08A_DRIVER

Port map ( CE => CEtest, WE => WEtest, OE => OEtest,
       Address => Addresstest,
       Data => Datatest1 );

MEMORY : MR2A08A
   Generic map (35 ns,
	            35 ns,
	            3 ns,
	            35 ns,
	            15 ns,
	            15 ns,
	            15 ns,
	            0 ns,
	            18 ns,
	            12 ns,
	            0 ns,
	            15 ns,
	            10 ns,
	            0 ns,
	            "MR2A08A.txt",
	            True)
       
      
      Port map ( E_b => CEtest , W_b => WEtest, G_b => OEtest,
       A => Addresstest,
      DQ => Datatest1); 


END TEST;

---------------------------------------------------------------------------

configuration CFG_BENCHTEST of BENCHTEST is
	for TEST
	end for;
end CFG_BENCHTEST;

----------------------------------------------------------------------------



