-- VHDL Test Sequence Generator for the 256K x 16 MRAM
-- Device Part Number: MR2A16A
-- Device Data Sheet: http://www.everspin.com/PDF/EST_MR2A16A_prod.pdf

-- Model Revision: 1.0
-- Model Release Date: August 2010

---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------
-----------------------------------------------------------
-- MR2A16A DRIVER
-----------------------------------------------------------

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
USE work.package_utility.ALL;
use ieee.std_logic_arith.all;
use ieee.numeric_std.all;

--=========================================================
-- ENTITY
--=========================================================
ENTITY MR2A16A_DRIVER IS
-----------------------------------------------------------

Port ( CE, WE, OE, BEH, BEL : OUT Std_Logic;
       Address : OUT Std_Logic_Vector(17 downto 0);
       Data : INOUT Std_Logic_Vector(15 downto 0):=(others=>'Z'));
       
      
-----------------------------------------------------------
END MR2A16A_DRIVER;

--=========================================================
ARCHITECTURE BENCH OF MR2A16A_DRIVER IS
--=========================================================

SIGNAL Chip_Enabled, Write_Enabled, Output_Enabled : STD_LOGIC := '0';
SIGNAL Address_outd: STD_Logic_Vector(17 downto 0);
SIGNAL Data_outd: STD_LOGIC_VECTOR(15 downto 0);


BEGIN
chip_enabled <= '1';

driver: process

CONSTANT thigh : TIME := 20 ns;
CONSTANT tlow  : TIME := 10 ns;

begin

-----------------------------------------------------------------------------------
-- Start Test 
-----------------------------------------------------------------------------------

WAIT FOR Thigh;
CE <= '0'; WE <= '1'; OE <= '1'; BEH <= '1'; BEL <= '1'; Data <= "1111111111111111"; Address <= "000000000000000001";

WAIT FOR 5*Thigh;
CE <= '1'; WE <= '1'; OE <= '1'; BEH <= '0'; BEL <= '0'; Address <= "ZZZZZZZZZZZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Write, CE, WE Setup prior to write
------------------------------------------------------------------------------------
WAIT FOR 2*Thigh;
Data <= "1111000000001111";
Address <= "000000000000000000";
WAIT FOR 10*Thigh;
CE <= '0'; WE <= '0'; OE <= '1'; 

WAIT FOR 2*Thigh;
CE <= '0'; WE <= '1'; OE <= '1';

WAIT FOR 2.5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000011";

WAIT FOR Thigh;
Data <= "ZZZZZZZZZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Read
------------------------------------------------------------------------------------
WAIT for 5*thigh;
CE <= '0'; WE <= '1'; OE <= '0'; Address <= "000000000000000000";

WAIT for 5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000000";

------------------------------------------------------------------------------------
-- Start Simple Byte Write, CE, WE Setup prior to write
------------------------------------------------------------------------------------
WAIT FOR 2*Thigh;
BEH <= '1';
Data <= "1111000010101010";
Address <= "000000000000000100";

WAIT FOR 10*Thigh;
CE <= '0'; WE <= '0'; OE <= '1'; 

WAIT FOR 2*Thigh;
CE <= '0'; WE <= '1'; OE <= '1';

WAIT FOR 2.5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000011";

WAIT FOR Thigh;
Data <= "ZZZZZZZZZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Read
------------------------------------------------------------------------------------
WAIT for 5*thigh;

BEH <= '0'; BEL <= '0';
CE <= '0'; WE <= '1'; OE <= '0'; Address <= "000000000000000100";

WAIT for 5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000100";

------------------------------------------------------------------------------------
-- Start Simple Byte Write, CE, WE Setup prior to write
------------------------------------------------------------------------------------
WAIT FOR 2*Thigh;
BEL <= '1';
Data <= "0101010110101010";
Address <= "000000000000000110";

WAIT FOR 10*Thigh;
CE <= '0'; WE <= '0'; OE <= '1'; 

WAIT FOR 2*Thigh;
CE <= '0'; WE <= '1'; OE <= '1';

WAIT FOR 2.5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000011";

WAIT FOR Thigh;
Data <= "ZZZZZZZZZZZZZZZZ";

------------------------------------------------------------------------------------
-- Start Simple Read
------------------------------------------------------------------------------------
WAIT for 5*thigh;
CE <= '0'; WE <= '1'; OE <= '0'; Address <= "000000000000000110";

WAIT for 5*tlow;
CE <= '1'; WE <= '1'; OE <= '1'; Address <= "000000000000000110";


--------------------------------------------------------------------------------------
-- End of Test Bench
--------------------------------------------------------------------------------------

end process;

end BENCH;


