---------------------------------------------------------------------
-- Project : MR4A16B VHDL TestBench
-- Release : 1.0
---------------------------------------------------------------------
-- Unit : test bench
-- Date : July 2010
---------------------------------------------------------------------
---------------------------------------------------------------------
-- These VHDL models are provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
---------------------------------------------------------------------

-----------------------------------------------------------
-- TEST BENCH
-----------------------------------------------------------
LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;
LIBRARY WORK;

LIBRARY STD;
USE STD.TEXTIO.ALL;

-----------------------------------------------------------
ENTITY BENCHTEST IS
END BENCHTEST;

-----------------------------------------------------------
-- Test architecture:
-----------------------------------------------------------
ARCHITECTURE TEST OF BENCHTEST IS

COMPONENT MR2A16A_DRIVER
---------------------------------------

Port ( CE, WE, OE, BEH, BEL : OUT Std_Logic;
      Address : OUT Std_Logic_Vector(17 downto 0);
       Data : INOUT Std_Logic_Vector(15 downto 0):=(others=>'Z'));
---------------------------------------
 END COMPONENT ;

COMPONENT MR2A16A
---------------------------------------
---------------------------------------
   Generic (  Tavav:   TIME;
	            Tavqv:   TIME;
	            Taxqx:   TIME;
	            Telqv:   TIME;
	            Tglqv:   TIME;
	            Tghqz:   TIME;
	            Tehqz:   TIME;
	            Tbhqz:   TIME;
	            Teleh:   TIME;
	            Tavwh:   TIME;
	            Twhax:   TIME;
	            Tavwl:   TIME;
	            Twlwh:   TIME;
	            Tdvwh:   TIME;
	            Twhdx:   TIME;
	            DataFile: STRING;
	            MemoryUpdate : Boolean);


Port ( E_b, W_b, G_b, LB_b, UB_b : IN Std_Logic;
       A : IN Std_Logic_Vector(17 downto 0);
       DQ : INOUT Std_Logic_Vector(15 downto 0));
---------------------------------------
END COMPONENT ;

SIGNAL CEtest, WEtest, OEtest, BELtest, BEHtest : STD_LOGIC;
SIGNAL Addresstest: STD_Logic_Vector(17 downto 0);
SIGNAL Datatest1: STD_LOGIC_VECTOR(15 downto 0);



-----------------------------------------------------------
-- body of structural architecture
-----------------------------------------------------------
BEGIN

TESTER : MR2A16A_DRIVER

Port map ( CE => CEtest, WE => WEtest, OE => OEtest,BEL => BELtest, BEH => BEHtest,
       Address => Addresstest,
       Data => Datatest1 );


MEMORY : MR2A16A
   Generic map (35 ns,
	            35 ns,
	            3 ns,
	            35 ns,
	            15 ns,
	            15 ns,
	            15 ns,
	            10 ns,
	            0 ns,
	            18 ns,
	            12 ns,
	            0 ns,
	            15 ns,
	            10 ns,
	            0 ns,
	            "mr2a16a.txt",
	            True)
       
      
      Port map ( E_b => CEtest , W_b => WEtest, G_b => OEtest, LB_b => BELtest, UB_b => BEHtest,
       A => Addresstest,
      DQ => Datatest1); 


END TEST;

---------------------------------------------------------------------------

configuration CFG_BENCHTEST of BENCHTEST is
	for TEST
	end for;
end CFG_BENCHTEST;

----------------------------------------------------------------------------



