/**********************************************************************

-- Configuration file for the M x 16 MRAM
-- Device Part Number: MR4A16B
-- Device Data Sheet: http://www.everspin.com/PDF/EST_MR4A16B_prod.pdf

-- This configuration file is used to define timing parameters for the end product,
-- To set new parameters, update this file

-- Model Revision: 1.0
-- Model Release Date: September 2010

---------------------------------------------------------------------
-- This Verilog models is provided "as is" without warranty of
-- any kind, included but not limited to, implied warranty of
-- merchant ability and fitness for a particular purpose.
-- Please refer to the datasheet for all specifications. 
-- Datasheet serves as the final arbiter of product performance
---------------------------------------------------------------------
*************************************************************************/

`ifdef MRAM35	
   `define	tavav	35	//write cycle time
   `define	twlwh	15	//write pulse width	
   `define	teleh	20	//chip enable to end of write
   `define	tdvwh	10	//data set-up to end of write
   `define	twlqz	15	//write enable to output disable
   `define	tehqz	15	//write enable to chip disable   
   `define	tghqz	10	//write enable to output disable   
   `define	tavwl	0	//address  set-up to start of write
   `define	twhax	12	//address hold after end of write 
   `define	tavav	35	//read cycle time
   `define	tglqv	15	//output enable to data valid
   `define	tavqv	35	//Address Access Time
   `define	taxqx	3	//Output Hold After Address Change
   `define      tbleh   15      //Byte Enable to end of write  - Chip Enable controlled
   `define      tblwh   15      //Byte enable to end of write - WE Controlled
   `define      tbhqz   10      //Byte Disable to Output Inactive
   `define      telwh   15
   `define      tavwh   20
   `define      twhdx   0
   `define      telqv   35
   `define      tblqv   15
   `define      tglqv   15
   `define      tglqx   0
   `define      telqx   3
   `define      twhqx   3
   `define      tblqx   0
   `define      tghqx   0
   `define      tehqx   0
   `define      tbhqx   0
`endif 
`ifdef MRAM45	
   `define	tavav	45	//write cycle time
   `define	twlwh	15	//write pulse width	
   `define	teleh	20	//chip enable to end of write
   `define	tdvwh	10	//data set-up to end of write
   `define	twlqz	15	//write enable to output disable
   `define	tehqz	15	//write enable to chip disable   
   `define	tghqz	10	//write enable to output disable   
   `define	tavwl	0	//address  set-up to start of write
   `define	twhax	12	//address hold after end of write 
   `define	tavav	45	//read cycle time
   `define	tglqv	15	//output enable to data valid
   `define	tavqv	45	//Address Access Time
   `define	taxqx	3	//Output Hold After Address Change
   `define      tbleh   15      //Byte Enable to end of write  - Chip Enable controlled
   `define      tblwh   15      //Byte enable to end of write - WE Controlled
   `define      tbhqz   10      //Byte Disable to Output Inactive
   `define      telwh   15
   `define      tavwh   20
   `define      twhdx   0
   `define      telqv   45
   `define      tblqv   15
   `define      tglqv   15
   `define      tglqx   0
   `define      telqx   3
   `define      twhqx   3
   `define      tblqx   0
   `define      tghqx   0
   `define      tehqx   0
   `define      tbhqx   0
`endif 
