//-------------------------------------------------------------------------------------------------
// 
//  st_mram_ddr4_parameters_1G.vh
//
//  Description: Everspin ST-MRAM DDR4 Behavioral Model Parameters File
//
//  Density:                1Gb (fixed)
//
//  REQUIRED Definitions:
//  WIDTH:                  X8 or X16
//  SPEED BIN:              DLL_OFF, BIN400, BIN1333, BIN1600, BIN1866, BIN2133, or BIN2400
//
//-------------------------------------------------------------------------------------------------
// 
//  This confidential and proprietary software may be used only as authorized 
//  by the included licensing agreement from Everspin titled 'EverspinSLA.txt'     
//
//                   Copyright 2016 Everspin Technologies, Inc
//
//  The entire notice above must be reproduced and the Everspin SLA included for 
//  all authorized copies.
//
//-------------------------------------------------------------------------------------------------
//  Revision Control Version:   $Revision: 1.46 $
//  Current Revision:           2.5
//
//  Revision History:
//  2.0     2018.08.31      CPM             - updated BIN1333 parameters to match datasheet
//  2.2     2018.10.02      CPM             - updated tCKSRE
//  2.3     2018.10.29      CPM             - version stamp
//  2.4     2018.11.19      CPM             - version stamp
//  2.5     2019.02.08      CPM             - added S1 S2 spec timing
//
//------------------------------------------------------------------------------------------------- 
/************************************************************************
 *
 * Procedural Parameters
 *
 ***********************************************************************/
parameter STOP_ON_ERROR = 0;        // 0=don't stop, 1=stop on errors
parameter STOP_ON_WARN  = 0;        // 0=don't stop, 1=stop on warnings
parameter VERBOSE_LEVEL = 5;        // 0-5: 0=no info; 5=show everything

/************************************************************************
 *
 *
 * Everspin 1Gb DDR4 ST-MRAM Addressing parameters
 *
 ***********************************************************************/
parameter CA_BITS = 7;
`ifdef X8
parameter BG_BITS = 2;
parameter DQ_BITS = 8;
`else
parameter BG_BITS = 1;
parameter DQ_BITS = 16;
`endif
parameter BA_BITS = 2;
parameter ADDR_BITS = 16;

/************************************************************************
 *
 * Speed Bin Parameters
 *
 ***********************************************************************/
`ifdef DLL_OFF
    parameter MAX_CL = 10;
    parameter MAX_CWL = 9;
    parameter TIS = 115;        // Input setup time
    parameter TIH = 140;        // Input hold time

    parameter TJIT_PER_TOT = 63;    //total clock period jitter
    parameter TJIT_PER_DJ = 31;        //deterministic clock period jitter
    parameter TJIT_PER_LCK = 50;    //clock period jitter during DLL locking period
    parameter TJIT_CC_TOT = 125;        //total cycle to cycle period jitter
    parameter TJIT_CC_DJ = 63;             //deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK = 100;        //cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER = 92;        //cumulative error across 2 cycles
    parameter TERR_3PER = 109;        //cumulative error across 3 cycles
    parameter TERR_4PER = 121;        //cumulative error across 4 cycles
    parameter TERR_5PER = 131;        //cumulative error across 5 cycles
    parameter TERR_6PER = 139;        //cumulative error across 6 cycles
    parameter TERR_7PER = 145;        //cumulative error across 7 cycles
    parameter TERR_8PER = 151;        //cumulative error across 8 cycles
    parameter TERR_9PER = 156;        //cumulative error across 9 cycles
    parameter TERR_10PER = 160;        //cumulative error across 10 cycles
    parameter TERR_11PER = 164;        //cumulative error across 11 cycles
    parameter TERR_12PER = 168;        //cumulative error across 12 cycles
    //parameter TERR_NPER = TBD;        //cumulative error across n cycles

    parameter TCK_DLL_OFF = 8_000;        //minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 2_500;        //minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 3_500;        //maximum Average Clock Period (ps)

    parameter TCH_AVG_MIN = 0.48;        //minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;        //maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;        //minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;        //maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        //minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        //maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;        //absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;        //absolute clock LOW pulse width

    parameter TDLLK = 1;                    // Number of clocks to DLL lock (DLL OFF)

    parameter TRRD_S_TCK = 4;                                // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;                                // ACT to ACT, same banks

    `ifdef X8
    parameter TRRD_S = 10_000;                                // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;                                // ACT to ACT, same banks
    `else
    parameter TRRD_S = 10_000;                                // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;                                // ACT to ACT, same banks
    `endif
`endif
/************************************************************************
 *
 * Speed Bin Parameters
 *
 ***********************************************************************/
`ifdef BIN800
    parameter MAX_CL = 10;
    parameter MAX_CWL = 9;
    parameter TIS = 115;        // Input setup time
    parameter TIH = 140;        // Input hold time

    parameter TJIT_PER_TOT = 63;    //total clock period jitter
    parameter TJIT_PER_DJ = 31;        //deterministic clock period jitter
    parameter TJIT_PER_LCK = 50;    //clock period jitter during DLL locking period
    parameter TJIT_CC_TOT = 125;        //total cycle to cycle period jitter
    parameter TJIT_CC_DJ = 63;             //deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK = 100;        //cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER = 92;        //cumulative error across 2 cycles
    parameter TERR_3PER = 109;        //cumulative error across 3 cycles
    parameter TERR_4PER = 121;        //cumulative error across 4 cycles
    parameter TERR_5PER = 131;        //cumulative error across 5 cycles
    parameter TERR_6PER = 139;        //cumulative error across 6 cycles
    parameter TERR_7PER = 145;        //cumulative error across 7 cycles
    parameter TERR_8PER = 151;        //cumulative error across 8 cycles
    parameter TERR_9PER = 156;        //cumulative error across 9 cycles
    parameter TERR_10PER = 160;        //cumulative error across 10 cycles
    parameter TERR_11PER = 164;        //cumulative error across 11 cycles
    parameter TERR_12PER = 168;        //cumulative error across 12 cycles
    //parameter TERR_NPER = TBD;        //cumulative error across n cycles

    parameter TCK_DLL_OFF = 8_000;        //minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 2_500;        //minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 3_500;        //maximum Average Clock Period (ps)

    parameter TCH_AVG_MIN = 0.48;        //minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;        //maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;        //minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;        //maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        //minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        //maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;        //absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;        //absolute clock LOW pulse width

    parameter TDLLK = 597;                    // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;                                // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;                                // ACT to ACT, same banks

    `ifdef X8
    parameter TRRD_S = 10_000;                                // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;                                // ACT to ACT, same banks
    `else
    parameter TRRD_S = 10_000;                                // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;                                // ACT to ACT, same banks
    `endif

`endif

`ifdef BIN1333
    parameter MAX_CL  = 12;             //
    parameter MAX_CWL = 11;             //
    parameter TIS     = 115;            // Input setup time
    parameter TIH     = 140;            // Input hold time

    parameter TJIT_PER_TOT = 63;        // total clock period jitter
    parameter TJIT_PER_DJ  = 31;        // deterministic clock period jitter
    parameter TJIT_PER_LCK = 50;        // clock period jitter during DLL locking period
    parameter TJIT_CC_TOT  = 125;       // total cycle to cycle period jitter
    parameter TJIT_CC_DJ   = 63;        // deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK  = 100;       // cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER    = 92;        // cumulative error across 2 cycles
    parameter TERR_3PER    = 109;       // cumulative error across 3 cycles
    parameter TERR_4PER    = 121;       // cumulative error across 4 cycles
    parameter TERR_5PER    = 131;       // cumulative error across 5 cycles
    parameter TERR_6PER    = 139;       // cumulative error across 6 cycles
    parameter TERR_7PER    = 145;       // cumulative error across 7 cycles
    parameter TERR_8PER    = 151;       // cumulative error across 8 cycles
    parameter TERR_9PER    = 156;       // cumulative error across 9 cycles
    parameter TERR_10PER   = 160;       // cumulative error across 10 cycles
    parameter TERR_11PER   = 164;       // cumulative error across 11 cycles
    parameter TERR_12PER   = 168;       // cumulative error across 12 cycles
    parameter TERR_NPER    = 999;       // cumulative error across n cycles - (1+0.68ln[n])*tjitPerMin

    parameter TCK_DLL_OFF = 8_000;      // minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 1_500;      // minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 1_600;      // maximum Average Clock Period (ps)
    parameter TCH_AVG_MIN = 0.48;       // minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;       // maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;       // minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;       // maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        // minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        // maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;       // absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;       // absolute clock LOW pulse width

    parameter TDLLK = 597;              // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;           // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;  // ACT to ACT, same banks

    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = 10_000;          // ACT to ACT, same banks


`endif

`ifdef BIN1600
    parameter MAX_CL  = 12;             //
    parameter MAX_CWL = 11;             //
    parameter TIS     = 115;            // Input setup time
    parameter TIH     = 140;            // Input hold time

    parameter TJIT_PER_TOT = 63;        // total clock period jitter
    parameter TJIT_PER_DJ  = 31;        // deterministic clock period jitter
    parameter TJIT_PER_LCK = 50;        // clock period jitter during DLL locking period
    parameter TJIT_CC_TOT  = 125;       // total cycle to cycle period jitter
    parameter TJIT_CC_DJ   = 63;        // deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK  = 100;       // cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER    = 92;        // cumulative error across 2 cycles
    parameter TERR_3PER    = 109;       // cumulative error across 3 cycles
    parameter TERR_4PER    = 121;       // cumulative error across 4 cycles
    parameter TERR_5PER    = 131;       // cumulative error across 5 cycles
    parameter TERR_6PER    = 139;       // cumulative error across 6 cycles
    parameter TERR_7PER    = 145;       // cumulative error across 7 cycles
    parameter TERR_8PER    = 151;       // cumulative error across 8 cycles
    parameter TERR_9PER    = 156;       // cumulative error across 9 cycles
    parameter TERR_10PER   = 160;       // cumulative error across 10 cycles
    parameter TERR_11PER   = 164;       // cumulative error across 11 cycles
    parameter TERR_12PER   = 168;       // cumulative error across 12 cycles
    parameter TERR_NPER    = 999;       // cumulative error across n cycles - (1+0.68ln[n])*tjitPerMin

    parameter TCK_DLL_OFF = 8_000;      // minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 1_250;      // minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 1_600;      // maximum Average Clock Period (ps)
    parameter TCH_AVG_MIN = 0.48;       // minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;       // maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;       // minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;       // maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        // minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        // maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;       // absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;       // absolute clock LOW pulse width

    parameter TDLLK = 597;              // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;           // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;  // ACT to ACT, same banks

    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = 10_000;          // ACT to ACT, same banks


`endif

`ifdef BIN1866
    parameter MAX_CL = 14;
    parameter MAX_CWL = 12;
    parameter TIS = 100;                // Input setup time
    parameter TIH = 125;                // Input hold time

    parameter TJIT_PER_TOT = 54;        //total clock period jitter
    parameter TJIT_PER_DJ = 27;         //deterministic clock period jitter
    parameter TJIT_PER_LCK = 43;        //clock period jitter during DLL locking period
    parameter TJIT_CC_TOT = 107;        //total cycle to cycle period jitter
    parameter TJIT_CC_DJ = 54;          //deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK = 86;         //cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER = 79;           // cumulative error across 2 cycles
    parameter TERR_3PER = 94;           // cumulative error across 3 cycles
    parameter TERR_4PER = 104;          // cumulative error across 4 cycles
    parameter TERR_5PER = 112;          // cumulative error across 5 cycles
    parameter TERR_6PER = 119;          // cumulative error across 6 cycles
    parameter TERR_7PER = 124;          // cumulative error across 7 cycles
    parameter TERR_8PER = 129;          // cumulative error across 8 cycles
    parameter TERR_9PER = 134;          // cumulative error across 9 cycles
    parameter TERR_10PER = 137;         // cumulative error across 10 cycles
    parameter TERR_11PER = 141;         // cumulative error across 11 cycles
    parameter TERR_12PER = 144;         // cumulative error across 12 cycles
    //parameter TERR_NPER = TBD;        // cumulative error across n cycles

    parameter TCK_DLL_OFF = 8_000;      //minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 1_071;      //minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 1_600;      //maximum Average Clock Period (ps)
    parameter TCH_AVG_MIN = 0.48;       //minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;       //maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;       //minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;       //maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        //minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        //maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;       //absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;       //absolute clock LOW pulse width

    parameter TDLLK = 597;              // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;           // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;  // ACT to ACT, same banks

    `ifdef X8
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `else
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `endif

`endif

`ifdef BIN2133
    parameter MAX_CL = 16;
    parameter MAX_CWL = 14;
    parameter TIS = 80;                 // Input setup time
    parameter TIH = 105;                // Input hold time

    parameter TJIT_PER_TOT = 47;        //total clock period jitter
    parameter TJIT_PER_DJ = 23;         //deterministic clock period jitter
    parameter TJIT_PER_LCK = 38;        //clock period jitter during DLL locking period
    parameter TJIT_CC_TOT = 94;         //total cycle to cycle period jitter
    parameter TJIT_CC_DJ = 47;          //deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK = 75;         //cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER = 69;           //cumulative error across 2 cycles
    parameter TERR_3PER = 82;           //cumulative error across 3 cycles
    parameter TERR_4PER = 91;           //cumulative error across 4 cycles
    parameter TERR_5PER = 98;           //cumulative error across 5 cycles
    parameter TERR_6PER = 104;          //cumulative error across 6 cycles
    parameter TERR_7PER = 109;          //cumulative error across 7 cycles
    parameter TERR_8PER = 113;          //cumulative error across 8 cycles
    parameter TERR_9PER = 120;          //cumulative error across 9 cycles
    parameter TERR_10PER = 123;         //cumulative error across 10 cycles
    parameter TERR_11PER = 126;         //cumulative error across 11 cycles
    parameter TERR_12PER = 129;         //cumulative error across 12 cycles
    //parameter TERR_NPER = TBD;        //cumulative error across n cycles

    parameter TCK_DLL_OFF = 8_000;      //minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 937;        //minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 1_600;      //maximum Average Clock Period (ps)
    parameter TCH_AVG_MIN = 0.48;       //minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;       //maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;       //minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;       //maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        //minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        //maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;       //absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;       //absolute clock LOW pulse width

    parameter TDLLK = 768;              // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;           // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;  // ACT to ACT, same banks

    `ifdef X8
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `else
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `endif

`endif

`ifdef BIN2400
    parameter MAX_CL = 18;
    parameter MAX_CWL = 16;
    parameter TIS = 62;                 // Input setup time
    parameter TIH = 87;                 // Input hold time

    parameter TJIT_PER_TOT = 42;        //total clock period jitter
    parameter TJIT_PER_DJ = 21;         //deterministic clock period jitter
    parameter TJIT_PER_LCK = 33;        //clock period jitter during DLL locking period
    parameter TJIT_CC_TOT = 83;         //total cycle to cycle period jitter
    parameter TJIT_CC_DJ = 42;          //deterministic cycle to cycle period jitter
    parameter TJIT_CC_LCK = 67;         //cycle to cycle period jitter during DLL locking period
    parameter TERR_2PER = 61;           //cumulative error across 2 cycles
    parameter TERR_3PER = 73;           //cumulative error across 3 cycles
    parameter TERR_4PER = 81;           //cumulative error across 4 cycles
    parameter TERR_5PER = 87;           //cumulative error across 5 cycles
    parameter TERR_6PER = 92;           //cumulative error across 6 cycles
    parameter TERR_7PER = 97;           //cumulative error across 7 cycles
    parameter TERR_8PER = 101;          //cumulative error across 8 cycles
    parameter TERR_9PER = 104;          //cumulative error across 9 cycles
    parameter TERR_10PER = 107;         //cumulative error across 10 cycles
    parameter TERR_11PER = 110;         //cumulative error across 11 cycles
    parameter TERR_12PER = 112;         //cumulative error across 12 cycles
    //parameter TERR_NPER = TBD;        //cumulative error across n cycles

    parameter TCK_DLL_OFF = 8_000;      //minimum clock cycle time (DLL off mode)
    parameter TCK_AVG_MIN = 833;        //minimum Average Clock Period (ps)
    parameter TCK_AVG_MAX = 1_600;      //maximum Average Clock Period (ps)
    parameter TCH_AVG_MIN = 0.48;       //minimum average high pulse width (tCK_avg)
    parameter TCH_AVG_MAX = 0.52;       //maximum average high pulse width (tCK_avg)
    parameter TCL_AVG_MIN = 0.48;       //minimum average low pulse width (tCK_avg)
    parameter TCL_AVG_MAX = 0.52;       //maximum average low pulse width (tCK_avg)
    parameter TCK_ABS_MIN = TCK_AVG_MIN - TJIT_PER_TOT;        //minimum absolute clock period
    parameter TCK_ABS_MAX = TCK_AVG_MAX + TJIT_PER_TOT;        //maximum absolute clock period
    parameter TCH_ABS_MIN = 0.45;       //absolute clock HIGH pulse width
    parameter TCL_ABS_MIN = 0.45;       //absolute clock LOW pulse width

    parameter TDLLK = 768;              // Number of clocks to DLL lock

    parameter TRRD_S_TCK = 4;           // ACT to ACT, different banks
    parameter TRRD_L_TCK = TRRD_S_TCK;  // ACT to ACT, same banks

    `ifdef X8
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `else
    parameter TRRD_S = 10_000;          // ACT to ACT, different banks
    parameter TRRD_L = TRRD_S;          // ACT to ACT, same banks
    `endif

`endif

// ************************************************************************
// *
// * Timing Parameters
// *
// ************************************************************************
parameter TST           = 150_000;              // STO 16:
parameter TST8          = TST*2;                // STO 8
parameter TST4          = TST*4;                // STO 4
parameter TST2          = TST*8;                // STO 2
parameter TRFC_MIN      = TST;                  // REF command to ACT or REF command time
parameter TXPR          = TRFC_MIN + 10_000;    // Exit reset from CKE HIGH to a valid command
parameter TXPR_TCK      = 5;                    //
`ifdef FAST_SIM
parameter TPW_RESET_S   =   200_000;            // RESET_S pulse low after power stable
parameter TPW_RESET_L   =   200_000;            // RESET_L pulse low at power-up
`else
parameter TPW_RESET_S   =  20_000_000;          // RESET_S pulse low after power stable
parameter TPW_RESET_L   = 200_000_000;          // RESET_L pulse low at power-up
`endif
parameter TCKE2RESET    = 10_000;               // cke low before reset_n high
parameter TRESET2CKE    = 500_000_000;          // cke high after reset_n high


parameter ZQ_INIT_CLKS  = 1024;                 // ZQCL: clocks
parameter TZQINIT       = ZQ_INIT_CLKS;         // ZQCL: command: Long calibration time during initialization
parameter ZQ_OPER_CLKS  = 512;                  // ZQCL: clocks
parameter TZQOPER       = ZQ_OPER_CLKS;         // ZQCL: command Long calibration time during Operation
parameter ZQ_ZQCS_CLKS  = 128;                  // ZQCS: clocks
parameter TZQCS         = ZQ_ZQCS_CLKS;         // ZQCS: command Short calibration time

parameter TADC_MIN      = 0.3;                  // RTT dynamic change skew
parameter TADC_MAX      = 0.7;                  // RTT
parameter TAONAS_MIN    = 1_000;                // RTT Asynchronous RTT(NOM) turn-on delay (DLL off) 
parameter TAONAS_MAX    = 9_000;                // RTT
//parameter TAOFAS                              // Not Used
//parameter TODTH8                              // Not Used
//parameter TODTH4                              // Not Used

//parameter TCAL_TCK      = 4;                  //x CS_n to Command Address Latency - Not Supported

`ifdef REV_S2
// REV_S2 silicon
parameter TRCD          = 135_000;              // ACT to read or write
parameter TRAS          = 143_000;              // ACT to PRE
parameter TRC           = 190_000;              // ACT to ACT, same bank (TRAS + TRP)
`else
// REV_S1 silicon
parameter TRCD          = 95_000;               // ACT to read or write
parameter TRAS          = 103_000;              // ACT to PRE
parameter TRC           = 150_000;              // ACT to ACT, same bank (TRAS + TRP)
`endif

parameter TRTP          = 5_000;                // Read to Precharge
parameter TRTP_TCK      = 4;                    //
parameter TRP           = 7_500;                // PRE command period
parameter TRP_TCK       = 4;                    // tRP min CK
parameter TCCD_S        = 4;                    // CAS to CAS delay for same BG
parameter TCCD_L        = 4;                    // CAS to CAS delay for different BG
parameter TWTR_S_TCK    = 6;                    // Write to Read delay for same BG
parameter TWTR_L_TCK    = 6;                    // Write to Read delay for different BG
parameter TWR           = 15_000;               // Write recovery time
parameter TREFI         = 7_800_000;            // Average periodic refresh interval
parameter TFAW          = 240_000;              // Four ACT window

parameter TMOD_TCK      = 24;                   // MRS:
parameter TMRD          = 8;                    // MRS: command cycle time (tCK)
parameter TMPRR_TCK     = 1;                    // MPR: Multipurpose register recovery time
parameter TWR_MPR       = TMOD_TCK;             // MPR: Multipurpose register write recovery time
parameter TMRD_PDA      = 10_000;               // MRS: command cycle time in PDA mode
parameter TMRD_PDA_TCK  = 16;                   // MRS:
parameter TMOD_PDA_TCK  = TMOD_TCK;             // MRS: command update delay
parameter TSDO          = 9_000;                // MRS: command to DQS drive in preamble training, TMOD_TCK + 9_000 computation at run time

parameter TWLMRD        = 40;                   // WL: First DQS_t, DQS_c rising edge after write leveling mode is programmed
parameter TWLDQSEN      = 25;                   // WL: DQS_t, DQS_c delay after write leveling mode is programmed
parameter TWLS          = 0.13;                 // WL: Write leveling setup from rising CK_t, CK_c crossing to rising DQS_t, DQS_c crossing
parameter TWLH          = 0.13;                 // WL: Write leveling hold from rising DQS_t, DQS_c crossing to rising CK_t, CK_c crossing
parameter TWLO          = 9_500;                // WL: Write leveling output delay
parameter TWLOE         = 2_000;                // WL: Write leveling output error

parameter TDQSS_MAX     = 0.27;                 // DQS:
parameter TDQSS_MIN     = 0.27;                 // DQS: minus
parameter TDQSL_MIN     = 0.46;                 // DQS: DQS_t, DQS_c differential input low pulse width
parameter TDQSL_MAX     = 0.54;                 // DQS:
parameter TDQSH_MIN     = 0.46;                 // DQS: DQS_t, DQS_c differential input high pulse width
parameter TDQSH_MAX     = 0.54;                 // DQS:


parameter TXP           = 6_000;                // PD: Exit power-down with DLL on to any valid command
parameter TXP_TCK       = 4;                    // PD:
parameter TCPDED        = 8;                    // PD: Command pass disable delay
parameter TCKE_MIN      = 5_000;                // PD: CKE MIN pulse width
parameter TCKE_MIN_TCK  = 3;                    // PD:
parameter TPD_MIN       = TCKE_MIN;             // PD: Power-down entry to power-down exit timing
parameter TPD_MIN_TCK   = TCKE_MIN_TCK;         // PD: Power-down entry to power-down exit timing
//parameter TANPD                               // Not Used
//parameter TPDE                                // Not Used
//parameter TPDX                                // Not Used
parameter TACTPDEN        = 1;                  // PD: ACTIVATE command to power-down entry
parameter TPRPDEN         = 1;                  // PD: PRECHARGE/PRECHARGE ALL command to power-down entry
parameter TREFPDEN        = 1;                  // PD: REFRESH command to power-down entry
parameter TMRSPDEN_TCK    = TMOD_TCK;           // PD: MRS command to power-down entry
// the RL/WL and WR and tWR/tCK will be added during the check computation based on what the operation was
parameter TRDPDEN_TCK     = 5;                  // PD: READ/READ with auto precharge command to power-down entry = RL + 4 + 1
parameter TWRPDEN_TCK     = 4;                  // PD: WRITE command to power-down entry (BL8OTF,BL8MRS, BC4OTF) = WL + 4 + tWR/tCKavg 
parameter TWRPBC4DEN_TCK  = 2;                  // PD: WRITE command to power-down entry (BC4MRS)                = WL + 2 + tWR/tCKavg
parameter TWRAPDEN_TCK    = 5;                  // PD: WRITE with auto precharge command to power-down entry (BL8OTF, BL8MRS,BC4OTF) = WL + 4 + WR + 1
parameter TWRAPBC4DEN_TCK = 3;                  // PD: WRITE with auto precharge command to power-down entry (BC4MRS) = WL + 2 + WR + 1

parameter TXS           = 10_000;               // SR: Exit self refresh to commands not requiring a locked DLL SRX to commands not requiring a locked DLL in self refresh abort
parameter TXS_ABORT     = 10_000;               // SR:
parameter TXS_FAST      = 10_000;               // SR: Exit self refresh to ZQCL, ZQCS and MRS (CL, CWL, WR, RTP and gear-down)
parameter TCKSRX        = 10_000;               // SR: Valid Clock Requirement before Self Refresh Exit (SRX) or Power-Down Exit (PDX) or Reset Exit
parameter TCKSRX_TCK    = 5;                    // SR:
parameter TCKSRE        = 10_000;               // SR: Valid clocks after self refresh entry (SRE) or power-down entry (PDE) *** MR decode of TST banks done at runtime
parameter TCKSRE_TCK    = 5;                    // SR:
parameter TXSDLL        = TDLLK;                // SR: Exit self refresh to commands requiring a locked DLL
parameter TCKESR        = TST;                  // SR: Minimum CKE low pulse width for self refresh entry to self refresh exit timing

parameter TMPED         = TMOD_TCK + TCPDED;    // MPSM: Command path disable delay upon MPSM entry, *** Need check for TMOD+TCPDED*Period and TMOD_CK+TCPDED
parameter TCKMPE        = TMOD_TCK + TCPDED;    // MPSM: Valid clock requirement after MPSM entry,   *** Need check for TMOD+TCPDED*Period and TMOD_CK+TCPDED
parameter TCKMPX        = TCKSRX;               // MPSM: Valid clock requirement before MPSM exit - 
parameter TXMP          = TXS;                  // MPSM: Exit MPSM to commands not requiring a locked DLL
parameter TXMP_DLL      = TXMP;                 // MPSM: Exit MPSM to commands requiring a locked DLL = TXMP + TXSDLL, TXSDLL is in nCK, XMP is in ns
parameter TMPX_S        = TIS + TIH;            // MPSM:
parameter TMPX_HH       = TXP;                  // MPSM: CS_n HIGH hold time to CKE rising edge
parameter TMPX_LH       = 12_000;               // MPSM: CS_n LOW hold time to CKE rising edge
parameter TMPX_LH_MAX   = TXMP - 10_000;        // MPSM:

parameter TCT_ENABLE    = 200_000;              // CT: TEN pin HIGH to CS_n LOW – Enter CT mode
parameter TCT_VALID     = 200_000;              // CT: CS_n LOW and valid input to valid output
parameter TCTECT_VALID  = 10_000;               // CT: CK_t, CK_c valid and CKE HIGH after TEN goes HIGH
//
// EOF
